/** file @geodist.c */
/** @file lonlat2tile.c */
#include <stdio.h>
#include <stdlib.h>
#include "projection.h"

static void usage(char **argv) {
  printf("Usage: %s lon0 lat0 lon1 lat1\n", argv[0]);
}

int main(int argc, char **argv) {
  struct FPoint p0, p1;
  double dist0, dist1;

  if (argc != 5) {
    usage(argv);
    exit(1);
  }
  p0.x = atof(argv[1]);
  p0.y = atof(argv[2]);
  p1.x = atof(argv[3]);
  p1.y = atof(argv[4]);
  dist0 = geodist0(p0, p1);
  dist1 = geodist1(p0, p1);
  printf("Sphere: %.03f WGS84: %.03f\n", dist0, dist1);
  return 0;
}

