/** @file lonlat2tile.c */
#include <stdio.h>
#include <stdlib.h>
#include "projection.h"

static void usage(char **argv) {
  printf("Usage: %s lon lat zoom\n", argv[0]);
}

int main(int argc, char **argv) {
  struct FPoint p;
  int z;
  struct Tile tile;

  if (argc != 4) {
    usage(argv);
    exit(1);
  }
  p.x = atof(argv[1]);
  p.y = atof(argv[2]);
  z = atoi(argv[3]);
  tile = lonLat2Tile(p, z);
  printf("%d_%d_%d\n", tile.z, tile.p.x, tile.p.y);
  return 0;
}
