/** @file projection.c */
#include <math.h>
#include "projection.h"

struct Tile lonLat2Tile(struct FPoint lonLat, int zoom) {
    struct Tile tile;
    int z;
    double lat;

    tile.z = zoom;
    lat = lonLat.y*M_PI/180.0;
    z = 1<<zoom;
    tile.p.x = (int)floor((lonLat.x+180.0)/360.0*z);
    tile.p.y = (int)floor((1.0-log(tan(lat)+1.0/cos(lat))/ M_PI) / 2.0 * z);
    return tile;
}

struct FPoint tile2LonLat(struct Tile tile) {
    struct FPoint p;
    double y;
    int z;

    z = 1<<tile.z;
    p.x = tile.p.x*360.0/z - 180.0;
    y = M_PI-2.0*M_PI*tile.p.y/z;
    p.y = 180.0/M_PI * atan(0.5*(exp(y)-exp(-y)));
    return p;
}

double geodist0(struct FPoint p0, struct FPoint p1) {
  double lon0, lat0, lon1, lat1;
  double zeta;

  lon0 = p0.x*M_PI/180.0;
  lat0 = p0.y*M_PI/180.0;
  lon1 = p1.x*M_PI/180.0;
  lat1 = p1.y*M_PI/180.0;
  zeta = sin(lat0)*sin(lat1)+cos(lat0)*cos(lat1)*cos(lon1-lon0);
  if (zeta > 1.0) zeta = 1.0;
  if (zeta < -1.0) zeta = -1.0;
  return acos(zeta)*6370.0;
}

double geodist1(struct FPoint p0, struct FPoint p1) {
  double f = 1.0/298.257223563; // Abplattung
  double a = 6378.137; // radius
  double ff, gg, l;
  double s, c, cosl, sinl, cosf, sinf, cosg, sing;
  double w, d, r, h1, h2;
  double dist;

  ff = 0.5*(p0.y+p1.y)*M_PI/180.0;
  gg = 0.5*(p1.y-p0.y)*M_PI/180.0;
  l = 0.5*(p1.x-p0.x)*M_PI/180.0;
  cosl = cos(l)*cos(l);
  sinl = sin(l)*sin(l);
  cosf = cos(ff)*cos(ff);
  sinf = sin(ff)*sin(ff);
  cosg = cos(gg)*cos(gg);
  sing = sin(gg)*sin(gg);
  s = sing*cosl+cosf*sinl;
  c = cosg*cosl+sinf*sinl;
  w = atan(sqrt(s/c));
  d = 2*w*a;
  r = sqrt(s*c)/w;
  h1 = (3*r-1)/(2*c);
  h2 = (3*r+1)/(2*s);
  dist = d*(1+f*h1*sinf*cosg-f*h2*cosf*sing);
  return dist;
}
