/** @file projection.h */
#ifndef PROJECTION_H
#define PROJECTION_H

struct Ipoint {
  int x;
  int y;
};

struct Tile {
  int z;
  struct Ipoint p;
};

struct FPoint {
  double x;
  double y;
};

struct Tile lonLat2Tile(struct FPoint lonLat, int zoom);
struct FPoint tile2LonLat(struct Tile tile);
double geodist0(struct FPoint p0, struct FPoint p1);
double geodist1(struct FPoint p0, struct FPoint p1);

#endif
