/** @file lonlat2tile.c */
#include <stdio.h>
#include <stdlib.h>
#include "projection.h"

static void usage(char **argv) {
  printf("Usage: %s lon0 lat0 lon1 lat1 zoom\n", argv[0]);
}

int main(int argc, char **argv) {
  struct FPoint p0, p1;
  int z;
  struct Tile tile0, tile1;
  int ix, iy;

  if (argc != 6) {
    usage(argv);
    exit(1);
  }
  p0.x = atof(argv[1]);
  p0.y = atof(argv[2]);
  p1.x = atof(argv[3]);
  p1.y = atof(argv[4]);
  z = atoi(argv[5]);
  tile0 = lonLat2Tile(p0, z);
  tile1 = lonLat2Tile(p1, z);
  for (iy = tile0.p.y; iy >= tile1.p.y; iy--) {
    for (ix = tile0.p.x; ix <= tile1.p.x; ix++) {
      printf("%d_%d_%d\n", tile0.z, ix, iy);
    }
  }
  return 0;
}

