/** @file tile2lonlat.c */
#include <stdio.h>
#include <stdlib.h>
#include "projection.h"

static void usage(char **argv) {
  printf("Usage: %s zoom tile_x tile_y\n", argv[0]);
}

int main(int argc, char **argv) {
  struct Tile tile0, tile1;
  struct FPoint p0, p1;

  if (argc != 4) {
    usage(argv);
    exit(1);
  }
  tile1.z = tile0.z = atoi(argv[1]);
  tile0.p.x = atoi(argv[2]);
  tile0.p.y = atoi(argv[3]);
  tile1.p.x = tile0.p.x + 1;
  tile1.p.y = tile0.p.y + 1;
  p0 = tile2LonLat(tile0);
  p1 = tile2LonLat(tile1);
  printf("%.06f,%.06f,%.06f,%.06f\n", p0.x, p1.y, p1.x, p0.y);
  return 0;
}
