/** @file tilesize.c */
#include <stdio.h>
#include <stdlib.h>
#include "projection.h"

static void usage(char **argv) {
  printf("Usage: %s z xNumber yNumber\n", argv[0]);
}

int main(int argc, char **argv) {
  struct Tile tile0, tile1;
  struct FPoint p0, p1;
  struct FPoint q0, q1;
  double dist0, dist1;

  if (argc != 4) {
    usage(argv);
    exit(1);
  }
  tile1.z = tile0.z = atoi(argv[1]);
  tile0.p.x = atof(argv[2]);
  tile0.p.y = atof(argv[3]);
  tile1.p.x = tile0.p.x+1;
  tile1.p.y = tile0.p.y+1;
  p0 = tile2LonLat(tile0);
  p1 = tile2LonLat(tile1);
  q0.x = p0.x;
  q1.x = p1.x;
  q0.y = q1.y = p1.y;
  dist0 = geodist0(q0, q1);
  dist1 = geodist1(q0, q1);
  printf("Lower edge: Sphere: %.03f WGS84: %.03f\n", dist0, dist1);
  q0.y = q1.y = p0.y;
  dist0 = geodist0(q0, q1);
  dist1 = geodist1(q0, q1);
  printf("Upper edge: Sphere: %.03f WGS84: %.03f\n", dist0, dist1);
  q0 = p0;
  q1.x = q0.x;
  q1.y = p1.y;
  dist0 = geodist0(q0, q1);
  dist1 = geodist1(q0, q1);
  printf("Vertical:   Sphere: %.03f WGS84: %.03f\n", dist0, dist1);
  dist0 = geodist0(p0, p1);
  dist1 = geodist1(p0, p1);
  printf("Diagonal:   Sphere: %.03f WGS84: %.03f\n", dist0, dist1);
  return 0;
}

